#include <TinyGPS.h>
#include <SoftwareSerial.h>

TinyGPS gps;
SoftwareSerial serialgps(69, 68); //Pin 69 equivale a A15 en arduino mega.

float latitud, longitud;
char LONGITUD_GPS[12];
char LATITUD_GPS[12];
char VELOCIDAD_GPS[5] = {'0', '0', '0', 0, 0};
char RUMBO_GPS[5] = {'0', '0', '0', 0, 0};
char HORA_GPS[4] = {'0', '0', 0, 0};
char MINUTOS_GPS[4] = {'0', '0', 0, 0};
char SEGUNDOS_GPS[4] = {'0', '0', 0, 0};
char DIA_GPS[4] = {'0', '0', 0, 0};
char MES_GPS[4] = {'0', '0', 0, 0};
char ANO_GPS[6] = {'0', '0', '0', '0', 0, 0};

int year;
byte month, day, hour, minute, second, hundredths;

void setup()
{
    serialgps.begin(9600);
    Serial.begin(9600);
    
}

void loop(){
   
    bool newData=false;
    unsigned long chars;
    unsigned short sentences, failed;
    
    for (unsigned long start = millis(); millis()-start<1000;)
    {
       while(serialgps.available()){
         {
           char c=serialgps.read();
           //Serial.write(c);
          
           if (gps.encode(c)){
             
             
             Serial.println("");
             //obtengo y muestro la latitud y la longitud
             gps.f_get_position(&latitud, &longitud);
             char latitudChar[10]= "";
             dtostrf(latitud,4,6,latitudChar);
             Serial.print("Latitud: ");
             Serial.println(latitudChar);
             char longitudChar[10]= "";
             dtostrf(longitud,4,6,longitudChar);
             Serial.print("Longitud: ");
             Serial.println(longitudChar);
             
             //obtengo y muestro la velocidad en nudos 
             int velocidad_gps = int(gps.f_speed_knots());
             sprintf(VELOCIDAD_GPS, "%03u", velocidad_gps);
             Serial.print("Velocidad: ");
             Serial.println(velocidad_gps);
             
             //Obtengo y muestro el rumbo.
             sprintf(RUMBO_GPS, "%03u", int(gps.f_course()));
             Serial.print("Rumbo: ");
             Serial.println(RUMBO_GPS);
             
             //Obtengo la fecha y la muestro usando el Serial.print
             gps.crack_datetime(&year, &month, &day, &hour, &minute, &second, &hundredths);
             sprintf(ANO_GPS, "%u", year);
             sprintf(DIA_GPS, "%02u", day);
             sprintf(MES_GPS, "%02u", month);
             sprintf(HORA_GPS, "%02u", hour);
             sprintf(MINUTOS_GPS, "%02u", minute);
             sprintf(SEGUNDOS_GPS, "%02u", second);
             Serial.print("Fecha: ");
             Serial.print(DIA_GPS);
             Serial.print("/");
             Serial.print(MES_GPS);
             Serial.print("/");
             Serial.println(ANO_GPS);
             //muestro la hora usando concatenacion
             String horaActual="";
             horaActual.concat(HORA_GPS); 
             horaActual.concat(":");
             horaActual.concat(MINUTOS_GPS);
             horaActual.concat(":");
             horaActual.concat(SEGUNDOS_GPS);
             
             Serial.print("Hora: ");
             Serial.println(horaActual);
             //Serial.println(horaActual);
           }
           
           
         }
       }
    }     
  
   
      
}

